// priority: 10

// --- 用户修改指南: 末地防逃课提示 ---
// 1. UI元素的位置 (Y坐标) 和对齐:
//    - `随机警告与传送提示1Y坐标`: -55 
//    - `传送提示2Y坐标`: 0 (配合alignY:"center")
//
// 2. UI元素的文本大小 (缩放):
//    - `随机警告与传送提示1缩放`: 2.0
//    - `传送提示2缩放`: 5.0
//
// 3. UI元素的文本颜色:
//    - `随机警告颜色`: "#FFFF55" (黄色)
//    - `传送提示1颜色`: "#FFFF55" (黄色)
//    - `传送提示2颜色`: "#FF5555" (红色)
//
// 4. 额外显示时长:
//    - `单条提示额外停留Ticks`: 60 (3秒) 文本打完后再停留的时间。
// --- 指南结束 ---

let 所有警告提示 = [
    "你不战而逃的行为触怒了祂!", "哼,想逃?幻影传送术!",
    "「旅人啊，龙瞳仍悬于破碎王庭！未熄的星焰在您足底结成枷锁 每粒末地沙都是倒数的审判钟，唯有染血的冠冕，能称量归途之重」",
    "亡命之徒,无路可逃", "你和龙娘的缘分未尽，她不想放你离开",
    "真理部宣：请勿擅自脱离作战区域，否则将被视为叛逃并遣返", "若迷惘，便会落败",
    "你逃不出我的手掌心/外来者，不可僭越", "终界之主:嘿嘿，你准备逃跑了吗",
    "此乃吾等镇压之地 尔等宵小，岂可肆意妄为。藏头鼠辈，直面汝等审判。",
    "击败巨龙之人，才有资格深入终末之地", "视界之下，命运暗涌。影龙盘踞，离岛之锁。斩其身，方能踏自由之途。"
];

let 逃课警告对话数据 = {
    "-1001": [
        ["你在混乱的空间迷失了方向", -55, 2.0, "#FFFF55", "center", "escape_prompt_line1"]
    ],
    "-1002": [
        ["祂将你带回了现实~", 0, 5.0, "#FF5555", "center", "escape_prompt_line2"]
    ]
};

// --- 首次登录欢迎消息配置 ---
//   "Y坐标": 当 "垂直对齐方式" 为 "center" 时, Y坐标是相对于屏幕垂直中心的偏移量。负值向上, 正值向下。
//            例如 -120 会将文本的中心点置于屏幕中心点上方120个GUI像素的位置。
//   "垂直对齐方式": "center" (推荐, 适应性更好), "top", "bottom"。
let 首次登录欢迎阶段配置 = {
    "1": { // 阶段序号，必须是字符串
        "文本": "欢迎穿越到§a异界战斗幻想~§5枪与魔法！",
        "Y坐标": -120,         // 调整后: 相对于屏幕中心向上120像素
        "缩放大小": 3.5,      
        "文本颜色": "#E6E6FA", // 粉色
        "水平对齐方式": "center",
        "垂直对齐方式": "center", 
        "UI元素ID": "welcome_message_ui",
        "打字后停留刻数": 100, // 5秒
        "下一阶段序号": "2"
    },
    "2": {
        "文本": "§d开始之前,请打开任务书查看介绍说明",
        "Y坐标": -120,         // 调整后: 相对于屏幕中心向上120像素 (比第一行稍低)
        "缩放大小": 3.0,      
        "文本颜色": "#B0E0E6", // 蓝色
        "水平对齐方式": "center",
        "垂直对齐方式": "center", 
        "UI元素ID": "welcome_message_ui", // ID相同, 第二条消息会覆盖第一条的位置
        "打字后停留刻数": 100, // 5秒
        "下一阶段序号": "完成"
    }
};
// --- 欢迎消息打字速度 ---
let 欢迎消息打字速度 = 2;

PlayerEvents.loggedIn(e => {
    let p = e.player;
    if (p.isFake()) return; 

    let pDATA = p.persistentData;

    if (pDATA.getBoolean("首次登录欢迎已完全显示") || 
        (pDATA.contains("当前欢迎阶段序号_paint") && pDATA.getString("当前欢迎阶段序号_paint") !== "完成")) {
        return;
    }
    e.server.scheduleInTicks(7*20, task => { // 延迟7秒
        pDATA.putString("当前欢迎阶段序号_paint", "1");
        pDATA.putString("当前欢迎阶段状态_paint", "打字中");
        pDATA.putInt("当前欢迎显示字符数_paint", 0);
        pDATA.putInt("欢迎打字机内部计数器_paint", 0);
    });
});

PlayerEvents.tick(e => {
    if (e.level.isClientSide() || e.player.isFake()) {
        return;
    }

    let p = e.player;
    let pDATA = p.persistentData;
    let 世界 = e.level;
    let 游戏刻 = 世界.time;
    let s = e.server;
    let 当前欢迎序号 = pDATA.getString("当前欢迎阶段序号_paint");

    if (当前欢迎序号 && 当前欢迎序号 !== "完成") {
        let 阶段配置 = 首次登录欢迎阶段配置[当前欢迎序号];
        if (!阶段配置) {
            pDATA.putString("当前欢迎阶段序号_paint", "完成");
            pDATA.putBoolean("首次登录欢迎已完全显示", true);
            return;
        }

        let 当前状态 = pDATA.getString("当前欢迎阶段状态_paint");
        let 界面元素ID = 阶段配置.UI元素ID;
        let 绘制参数 = {};

        if (当前状态 === "打字中") {
            let 内部计数器 = pDATA.getInt("欢迎打字机内部计数器_paint");
            let 已显示字符数 = pDATA.getInt("当前欢迎显示字符数_paint");
            let 全文本 = 阶段配置.文本;

            if (内部计数器 % 欢迎消息打字速度 === 0) {
                if (已显示字符数 < 全文本.length) {
                    已显示字符数++;
                    pDATA.putInt("当前欢迎显示字符数_paint", 已显示字符数);
                }
            }
            pDATA.putInt("欢迎打字机内部计数器_paint", 内部计数器 + 1);

            let 显示文本 = 全文本.slice(0, 已显示字符数);
            绘制参数[界面元素ID] = {
                "type": "text", "text": 显示文本, "visible": true,
                "alignX": 阶段配置.水平对齐方式,
                "alignY": 阶段配置.垂直对齐方式,
                "x": 0, "y": 阶段配置.Y坐标, "scale": 阶段配置.缩放大小,
                "color": 阶段配置.文本颜色, "shadow": true, "draw": "ingame"
            };
            p.paint(绘制参数);

            if (已显示字符数 >= 全文本.length) {
                pDATA.putString("当前欢迎阶段状态_paint", "停留中");
                pDATA.putLong("欢迎阶段停留结束时刻_paint", 游戏刻 + 阶段配置.打字后停留刻数);
                pDATA.putInt("欢迎打字机内部计数器_paint", 0);
            }
        } else if (当前状态 === "停留中") {
            绘制参数[界面元素ID] = {
                "type": "text", "text": 阶段配置.文本, "visible": true,
                "alignX": 阶段配置.水平对齐方式,
                "alignY": 阶段配置.垂直对齐方式,
                "x": 0, "y": 阶段配置.Y坐标, "scale": 阶段配置.缩放大小,
                "color": 阶段配置.文本颜色, "shadow": true, "draw": "ingame"
            };
            p.paint(绘制参数);

            let 停留结束时刻 = pDATA.getLong("欢迎阶段停留结束时刻_paint");
            if (游戏刻 >= 停留结束时刻) {
                绘制参数[界面元素ID] = { "visible": false, "shadow": false };
                p.paint(绘制参数);

                let 下一序号 = 阶段配置.下一阶段序号;
                if (下一序号 === "完成") {
                    pDATA.putString("当前欢迎阶段序号_paint", "完成");
                    pDATA.putBoolean("首次登录欢迎已完全显示", true);
                    pDATA.remove("当前欢迎阶段状态_paint");
                    pDATA.remove("当前欢迎显示字符数_paint");
                    pDATA.remove("欢迎打字机内部计数器_paint");
                    pDATA.remove("欢迎阶段停留结束时刻_paint");
                } else {
                    pDATA.putString("当前欢迎阶段序号_paint", 下一序号);
                    pDATA.putString("当前欢迎阶段状态_paint", "打字中");
                    pDATA.putInt("当前欢迎显示字符数_paint", 0);
                    pDATA.putInt("欢迎打字机内部计数器_paint", 0);
                }
            }
        }
    }

    let 当前提示ID值 = pDATA.getInt("当前特殊提示ID");
    let 当前提示阶段值 = pDATA.getInt("当前特殊提示阶段");

    if (当前提示ID值 < 0) {
        let 警告文本内容 = null;
        let 警告界面元素ID = "";
        let Y坐标 = 0;
        let 缩放大小 = 1.0;
        let 文本颜色 = "#FFFFFF";
        let 水平对齐方式 = "center";
        let 垂直对齐方式 = "bottom";

        if (逃课警告对话数据[当前提示ID值]) {
            let 配置 = 逃课警告对话数据[当前提示ID值][0];
            警告文本内容 = 配置[0];
            Y坐标 = 配置[1];
            缩放大小 = 配置[2];
            文本颜色 = 配置[3];
            水平对齐方式 = 配置[4];
            警告界面元素ID = 配置[5];
            if (Y坐标 === 0 && 水平对齐方式 === "center" && 缩放大小 > 2.0) 垂直对齐方式 = "center";
        } else if (当前提示ID值 === -1 && pDATA.contains("逃课警告_临时文本")) {
            警告文本内容 = pDATA.getString("逃课警告_临时文本");
            Y坐标 = pDATA.getInt("逃课警告_临时Y");
            缩放大小 = pDATA.getFloat("逃课警告_临时Scale");
            文本颜色 = pDATA.getString("逃课警告_临时Color");
            水平对齐方式 = pDATA.getString("逃课警告_临时AlignX");
            警告界面元素ID = pDATA.getString("逃课警告_临时UiId");
            if (Y坐标 === 0 && 水平对齐方式 === "center" && 缩放大小 > 2.0) 垂直对齐方式 = "center";
        }

        if (警告文本内容 && 警告界面元素ID) {
            let 完整文本 = 警告文本内容;
            let 结束时刻 = pDATA.getLong("逃课警告_结束时刻");
            let 绘制参数警告 = {};

            if (游戏刻 >= 结束时刻) {
                绘制参数警告[警告界面元素ID] = { "type": "text", "visible": false, "shadow": false };
                p.paint(绘制参数警告);
                pDATA.putInt("当前特殊提示ID", 0);
                pDATA.putInt("当前特殊提示阶段", 0);
                pDATA.remove("逃课警告_临时文本");
                pDATA.remove("逃课警告_临时Y"); pDATA.remove("逃课警告_临时Scale"); pDATA.remove("逃课警告_临时Color");
                pDATA.remove("逃课警告_临时AlignX"); pDATA.remove("逃课警告_临时UiId");
                pDATA.remove("逃课警告_结束时刻");
            } else {
                let 显示字符数 = 当前提示阶段值 + 1;
                if (显示字符数 > 完整文本.length) 显示字符数 = 完整文本.length;

                let 显示文本 = 完整文本.slice(0, 显示字符数);

                绘制参数警告[警告界面元素ID] = {
                    "type": "text", "text": 显示文本, "visible": true,
                    "alignX": 水平对齐方式, "alignY": 垂直对齐方式,
                    "x": 0, "y": Y坐标, "scale": 缩放大小,
                    "color": 文本颜色, "shadow": true, "draw": "ingame"
                };
                p.paint(绘制参数警告);
                pDATA.putInt("当前特殊提示阶段", 当前提示阶段值 + 1);
            }
        } else {
            pDATA.putInt("当前特殊提示ID", 0); pDATA.putInt("当前特殊提示阶段", 0);
        }
    }

    if (p.age % 100 === 1 && pDATA.getInt("当前特殊提示ID") === 0 && (!pDATA.contains("当前欢迎阶段序号_paint") || pDATA.getString("当前欢迎阶段序号_paint") === "完成")) {
        
        if (p.isCreative() || p.isSpectator()) {
            return; 
        }
        
        let 维度ID = 世界.dimension.toString();

        if (维度ID === "minecraft:the_end") {
            let 末影龙战斗 = 世界.dragonFight;
            let 终界之主是否已击杀 = 末影龙战斗 != null && 末影龙战斗.hasPreviouslyKilledDragon();

            if (!终界之主是否已击杀) {
                let X坐标绝对值 = Math.abs(p.x);
                let Z坐标绝对值 = Math.abs(p.z);

                let 单条额外停留Ticks = 60;
                let 随机警告与传送提示1Y坐标 = -55;
                let 随机警告与传送提示1缩放 = 2.0;
                let 随机警告颜色 = "#FFFF55";
                let UI元素ID1 = "escape_prompt_line1";

                if (X坐标绝对值 > 300 || Z坐标绝对值 > 300) {
                    let 目标实体 = p;
                    let 闪电 = 世界.createEntity("minecraft:lightning_bolt");
                    if (闪电) { 闪电.setPos(目标实体.x, 目标实体.y, 目标实体.z); 闪电.spawn(); }

                    s.scheduleInTicks(10, task_teleport => {
                        if (!p || !p.server) return;
                        let 主世界 = s.getLevel("minecraft:overworld");
                        let 重生点位置 = 主世界.getSharedSpawnPos();
                        s.tell(`§a玩家 §b${p.name.string} §a逃课被送回主世界`);
                        p.teleportTo("minecraft:overworld", 重生点位置.x + 0.5, 重生点位置.y, 重生点位置.z + 0.5, p.yaw, p.pitch);

                        pDATA.putInt("当前特殊提示ID", -1001);
                        pDATA.putInt("当前特殊提示阶段", 0);
                        let 文本1长度 = 逃课警告对话数据[-1001][0][0].length;
                        pDATA.putLong("逃课警告_结束时刻", 世界.time + 10 + 文本1长度 + 单条额外停留Ticks);

                        s.scheduleInTicks(10 + 文本1长度 + 单条额外停留Ticks + 5, task_show_line2 => {
                            if (!p || !p.server) return;
                            if (pDATA.getInt("当前特殊提示ID") === 0 || pDATA.getInt("当前特殊提示ID") === -1001) {
                                pDATA.putInt("当前特殊提示ID", -1002);
                                pDATA.putInt("当前特殊提示阶段", 0);
                                let 文本2长度 = 逃课警告对话数据[-1002][0][0].length;
                                pDATA.putLong("逃课警告_结束时刻", 世界.time + 文本2长度 + 单条额外停留Ticks);
                            }
                        });
                    });
                    return;
                }
                else if (X坐标绝对值 > 150 || Z坐标绝对值 > 150) {
                    if (pDATA.getInt("当前特殊提示ID") === 0) {
                        let 随机索引 = Math.floor(Math.random() * 所有警告提示.length);
                        let 随机警告文本 = 所有警告提示[随机索引];
                        pDATA.putString("逃课警告_临时文本", 随机警告文本);
                        pDATA.putInt("逃课警告_临时Y", 随机警告与传送提示1Y坐标);
                        pDATA.putFloat("逃课警告_临时Scale", 随机警告与传送提示1缩放);
                        pDATA.putString("逃课警告_临时Color", 随机警告颜色);
                        pDATA.putString("逃课警告_临时AlignX", "center");
                        pDATA.putString("逃课警告_临时UiId", UI元素ID1);
                        pDATA.putInt("当前特殊提示ID", -1);
                        pDATA.putInt("当前特殊提示阶段", 0);
                        pDATA.putLong("逃课警告_结束时刻", 游戏刻 + 随机警告文本.length + 单条额外停留Ticks);
                    }
                }
            }
        }
    }
});

PlayerEvents.loggedOut(e => {
    let p = e.player;
    if (p && !p.isFake()) {
        let pDATA = p.persistentData;
        let 当前欢迎序号_登出 = pDATA.getString("当前欢迎阶段序号_paint");
        if (当前欢迎序号_登出 && 当前欢迎序号_登出 !== "完成") {
            let 阶段配置_登出 = 首次登录欢迎阶段配置[当前欢迎序号_登出];
            if (阶段配置_登出 && 阶段配置_登出.UI元素ID) {
                let 清除参数 = {};
                清除参数[阶段配置_登出.UI元素ID] = { "visible": false, "shadow": false };
                p.paint(清除参数);
            }
        }
        if (!pDATA.getBoolean("首次登录欢迎已完全显示")) {
            pDATA.remove("当前欢迎阶段序号_paint");
            pDATA.remove("当前欢迎阶段状态_paint");
            pDATA.remove("当前欢迎显示字符数_paint");
            pDATA.remove("欢迎打字机内部计数器_paint");
            pDATA.remove("欢迎阶段停留结束时刻_paint");
        }
        let 当前提示ID值 = pDATA.getInt("当前特殊提示ID");
        if (当前提示ID值 < 0) {
            let 需清除的UI = "";
            if (逃课警告对话数据[当前提示ID值]) {
                需清除的UI = 逃课警告对话数据[当前提示ID值][0][5];
            } else if (当前提示ID值 === -1 && pDATA.contains("逃课警告_临时UiId")) {
                需清除的UI = pDATA.getString("逃课警告_临时UiId");
            }
            if (需清除的UI) {
                let 清除Paint = {}; 清除Paint[需清除的UI] = { "visible": false, "shadow": false }; p.paint(清除Paint);
            }
        }
        pDATA.putInt("当前特殊提示ID", 0);
        pDATA.putInt("当前特殊提示阶段", 0);
        pDATA.remove("逃课警告_临时文本");
        pDATA.remove("逃课警告_临时Y");
        pDATA.remove("逃课警告_临时Scale");
        pDATA.remove("逃课警告_临时Color");
        pDATA.remove("逃课警告_临时AlignX");
        pDATA.remove("逃课警告_临时UiId");
        pDATA.remove("逃课警告_结束时刻");
    }
});
